/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.logstream;

import io.quarkus.vertx.http.runtime.devmode.Json;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeMap;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;

public class LogController {
    private static final org.jboss.logging.Logger LOG = org.jboss.logging.Logger.getLogger(LogController.class);
    public static final List<String> LEVELS = List.of(Level.OFF.getName(), Level.SEVERE.getName(), Level.ERROR.getName(), Level.FATAL.getName(), Level.WARNING.getName(), Level.WARN.getName(), Level.INFO.getName(), Level.DEBUG.getName(), Level.TRACE.getName(), Level.CONFIG.getName(), Level.FINE.getName(), Level.FINER.getName(), Level.FINEST.getName(), Level.ALL.getName());

    private LogController() {
    }

    public static Json.JsonArrayBuilder getLevels() {
        Json.JsonArrayBuilder array = Json.array();
        for (String level : LEVELS) {
            array.add(level);
        }
        return array;
    }

    public static Json.JsonArrayBuilder getLoggers() {
        LogContext logContext = LogContext.getLogContext();
        TreeMap<String, Json.JsonObjectBuilder> loggerMap = new TreeMap<String, Json.JsonObjectBuilder>();
        Enumeration loggerNames = logContext.getLoggerNames();
        while (loggerNames.hasMoreElements()) {
            String loggerName = (String)loggerNames.nextElement();
            Json.JsonObjectBuilder jsonObject = LogController.getLogger(loggerName);
            if (jsonObject == null) continue;
            loggerMap.put(loggerName, jsonObject);
        }
        ArrayList<Json.JsonObjectBuilder> orderedLoggers = new ArrayList<Json.JsonObjectBuilder>(loggerMap.values());
        Json.JsonArrayBuilder jsonArray = Json.array();
        jsonArray.addAll(orderedLoggers);
        return jsonArray;
    }

    public static Json.JsonObjectBuilder getLogger(String loggerName) {
        LogContext logContext = LogContext.getLogContext();
        if (loggerName != null && !loggerName.isEmpty()) {
            Logger logger = logContext.getLogger(loggerName);
            Json.JsonObjectBuilder jsonObject = Json.object();
            jsonObject.put("name", loggerName);
            jsonObject.put("effectiveLevel", LogController.getEffectiveLogLevel(logger));
            jsonObject.put("configuredLevel", LogController.getConfiguredLogLevel(logger));
            return jsonObject;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void updateLogLevel(String loggerName, String levelValue) {
        java.util.logging.Level level;
        LogContext logContext = LogContext.getLogContext();
        Logger logger = logContext.getLogger(loggerName);
        if (levelValue == null || levelValue.isBlank()) {
            if (logger.getParent() == null) throw new IllegalArgumentException("The level of the root logger cannot be set to null");
            level = logger.getParent().getLevel();
        } else {
            level = java.util.logging.Level.parse(levelValue);
        }
        logger.setLevel(level);
        LOG.info((Object)("Log level updated [" + loggerName + "] changed to [" + levelValue + "]"));
    }

    private static String getConfiguredLogLevel(Logger logger) {
        java.util.logging.Level level = logger.getLevel();
        return level != null ? level.getName() : null;
    }

    private static String getEffectiveLogLevel(Logger logger) {
        if (logger == null) {
            return null;
        }
        if (logger.getLevel() != null) {
            return logger.getLevel().getName();
        }
        return LogController.getEffectiveLogLevel(logger.getParent());
    }
}

