/*
 * Decompiled with CFR 0.152.
 */
package com.yovendo.printer.print;

import com.yovendo.printer.print.Impresora;
import com.yovendo.printer.print.TrabajoImpresion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ApplicationScoped
public class SistemaImpresion
implements Serializable {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private static final long serialVersionUID = 1L;
    private List<Impresora> listaImpresoras = new ArrayList<Impresora>();
    private List<TrabajoImpresion> listaTrabajosImpresion = new ArrayList<TrabajoImpresion>();

    public SistemaImpresion() {
        this.logger.info("SistemaImpresion constuctor...");
    }

    public List<Impresora> getListaImpresoras() {
        return this.listaImpresoras;
    }

    public void setListaImpresoras(List<Impresora> listaImpresoras) {
        this.listaImpresoras = listaImpresoras;
    }

    public Boolean agregarImpresora(Impresora impresora) {
        return this.listaImpresoras.add(impresora);
    }

    public Boolean eliminarImpresora(Impresora impresora) {
        return this.listaImpresoras.remove(impresora);
    }

    public Boolean existeImpresora(Impresora impresora) {
        return this.listaImpresoras.contains(impresora);
    }

    public Boolean actualizarListaImpresoras(List<Impresora> impresoras) {
        Boolean t;
        if (this.listaImpresoras == null) {
            this.listaImpresoras = new ArrayList<Impresora>();
            t = this.listaImpresoras.addAll(impresoras);
        } else {
            t = this.listaImpresoras.retainAll(impresoras);
            impresoras.stream().filter(impresora -> this.existeImpresora((Impresora)impresora) == false).forEach(impresora -> this.listaImpresoras.add((Impresora)impresora));
        }
        return t;
    }

    public List<TrabajoImpresion> getListaTrabajosImpresion() {
        return this.listaTrabajosImpresion;
    }

    public void setListaTrabajosImpresion(List<TrabajoImpresion> listaTrabajosImpresion) {
        this.listaTrabajosImpresion = listaTrabajosImpresion;
    }

    public static String obtenerRutaBase() {
        return System.getProperty("user.home");
    }
}

