/*
 * Decompiled with CFR 0.152.
 */
package com.yovendo.printer.controlador;

import com.yovendo.printer.print.TrabajoImpresion;
import com.yovendo.printer.servicio.ImpresionServicio;
import com.yovendo.printer.util.RespuestaControlador;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Path(value="/impresion")
@RequestScoped
public class ImpresionControlador {
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    @Inject
    private ImpresionServicio impresionServicio;

    @GET
    @Path(value="/impresora")
    public RespuestaControlador obtenerImpresoras() {
        RespuestaControlador respuestaControlador;
        try {
            respuestaControlador = RespuestaControlador.obtenerRespuestaExitoConData(this.impresionServicio.listarImpresoras());
        }
        catch (Exception exception) {
            this.logger.error((Object)exception, (Throwable)exception);
            respuestaControlador = RespuestaControlador.obtenerRespuestaDeError("Ocurrio un error al obtener impresoras.");
        }
        return respuestaControlador;
    }

    @GET
    @Path(value="/pcactual")
    public RespuestaControlador obtenerPcActual() {
        RespuestaControlador respuestaControlador;
        try {
            respuestaControlador = RespuestaControlador.obtenerRespuestaExitoConData(this.impresionServicio.obtenerPcActual());
        }
        catch (Exception exception) {
            this.logger.error((Object)exception, (Throwable)exception);
            respuestaControlador = RespuestaControlador.obtenerRespuestaDeError("Ocurrio un error al obtener pc actual.");
        }
        return respuestaControlador;
    }

    @POST
    @Path(value="/imprimir")
    public RespuestaControlador imprimir(TrabajoImpresion trabajoImpresion) {
        RespuestaControlador respuestaControlador;
        try {
            respuestaControlador = RespuestaControlador.obtenerRespuestaExitoConData(this.impresionServicio.imprimir(trabajoImpresion));
        }
        catch (Exception exception) {
            this.logger.error((Object)exception, (Throwable)exception);
            respuestaControlador = RespuestaControlador.obtenerRespuestaDeError("Ocurrio un error al imprimir.");
        }
        return respuestaControlador;
    }
}

